require('dotenv').config();
const express = require('express');
const app          = express();
const session      = require('express-session');
const path         = require('path');
const clearCache = require('nocache');
const { login_checker } = require('./globalMiddleware/auth');
const adminDashboard = require('./routes/admin-routes');
const adminController = require('./controllers/adminController');

app.use(clearCache()); 
app.use(express.urlencoded({ extended: true }));
app.use(express.json());
app.use(express.static('public'));

app.use(session({
  cookie: {
    path    : '/',
    httpOnly: false,
  },
  secret: '1234567890QWERT',
  saveUninitialized: true,
  resave: false,
}));

app.get('/logout',(req,res)=>{
    
    req.session.destroy();
    res.redirect('/login');
});

app.get('/', (req, res) => {
  return res.redirect('/logout');
})
app.get('/login', (req,res)=> {
  return res.render('login-form');
});
app.post('/login', adminController.login);

app.use('/dashboard',login_checker, adminDashboard);

app.set('views', path.join(__dirname, 'views'));
app.set('view engine', 'ejs');

module.exports = app;