const { DataTypes } = require("sequelize");
const sequelize = require("../config/db");
const bcrypt = require('bcryptjs')

const users = sequelize.define('users', {
    id:{
        type : DataTypes.INTEGER,
        primaryKey : true,
        autoIncrement : true,
    },
    firstName : {
        type : DataTypes.STRING,
        allowNull : false,
    },
    lastName : {
        type : DataTypes.STRING,
        allowNull : false,
    },
    mobileNumber : {
        type : DataTypes.STRING,
        allowNull : true,
    },
    userRole : {
        type : DataTypes.TINYINT,
        allowNull : false,
    },
    email : {
        type : DataTypes.STRING,
        allowNull : false,
    },
    password : {
        type : DataTypes.STRING,
        allowNull : false,
    }
},
{
        timestamps: true,
        hooks: {
            beforeCreate: async (users, option) => {
                if (users.dataValues.password) {
                    users.dataValues.password = await bcrypt.hash(users.dataValues.password, 10)
                }
            },
            beforeUpdate: async (users, option) => {
                if (users.dataValues.password) {
                    users.dataValues.password = await bcrypt.hash(users.dataValues.password, 10)
                }
            }
        }
    }
);

users.validPassword = async (password, hash) => {
    return await bcrypt.compare(password, hash);
};

module.exports = users;