const { DataTypes } = require("sequelize");
const sequelize = require("../config/db");
const users = require("./userModel");

const products = sequelize.define('products', {
    id:{
        type : DataTypes.INTEGER,
        primaryKey : true,
        autoIncrement : true,
    },
    productId : {
        type : DataTypes.INTEGER,
        allowNull : false,
    },
    name : {
        type : DataTypes.STRING,
        allowNull : false,
    },
    addedBy : {
        type : DataTypes.INTEGER,
        references :{
            model : 'users',
            key : 'id',
        }
    },   
},
{
    timestamps: true,        
}
);

products.belongsTo(users,{foreignKey:'addedBy', as: 'addedByUser'});

module.exports = products;