const productsModel = require("../models/productModel");
const usersModel = require("../models/userModel");

module.exports.login = async (req, res) => {
    try {
       console.log("Enter to login", req.body);
       const { username, password } = req.body;
       if(!username || !password){
            return  res.render("login-form", {
            usererror: "Both username and password are required"
        });    
       } 

       const userExist = await usersModel.findOne({where: {email: username}});
       if(!userExist) return res.render("login-form", {
            usererror: "Invalid UserName"
        });

       const validUser = await usersModel.validPassword(password, userExist.password);
       console.log("validUser", validUser);       
       if (!validUser) return res.render("login-form", {
            usererror: "Invalid Credentials"
        });

       req.session.user = userExist?.dataValues;
       await req.session.save();         
       return res.redirect("/dashboard");
    } catch (error) {
        console.log("Error occur while logging",error);
        return res.render("login-form", {
            usererror: "Error occur while login, please try after some time"
        });
    }
}

module.exports.fetchAllProducts = async (req, res) => {
    try {
        const allproducts = await productsModel.findAll();
        const products = allproducts || [];

        return res.status(200).render("products-listing", {
            active : 'ProductManagement',
            products : products
        });

    } catch (error) {
        console.log("Error occur while getting all products", error);
        return res.status(400).render("products-listing", {
            active : 'ProductManagement',
            products : [],
            error: "Failed To Fetch All Products"
        });
    }
};


module.exports.upsertProducts = async (req, res) => {
    try {
        const id = req.body.existingProductId;
        const data = {
            productId: req.body.productID,
            name: req.body.productName
        };

        if (id) {
            const updateProduct = await productsModel.update(data, { where: { id }});
            if (updateProduct[0] === 1) return res.redirect('/dashboard/productManagement');
        } else {
            const createProduct = await productsModel.create(data);
            if (createProduct) return res.redirect('/dashboard/productManagement');
        }

        return res.redirect('/dashboard/productManagement');

    } catch (error) {
        console.log("Error occur while upserting the product", error);
        return res.status(400).send({ error });
    }
};

module.exports.checkProductExist = async (req, res) => {
    try {
        const { productID } = req.body;

        // Check product ID existence separately
        if (productID) {
            const existingById = await productsModel.findOne({
                where: { productId: productID }
            });
            return res.json({ exists: !!existingById });
        }        

        return res.json({ exists: false });

    } catch (error) {
        console.log("Error while checking product existence", error);
        return res.status(400).json({ error: error.message });
    }
};





module.exports.deleteProduct = async (req, res) => {
    try {
        const id = req.body.productId;
        console.log("req.body",req.body);      

        if (id) {
            const deleteProduct = await productsModel.destroy({ where: { id }});
            if (deleteProduct === 1) return res.redirect("/dashboard/productManagement");
        }

        return res.redirect("/dashboard/productManagement");

    } catch (error) {
        console.log("Error occur while deleting product", error);
        return res.status(400).send({ error : error });
    }
};


