$(document).ready(function () {

    $.validator.addMethod("noSpace", function (value, element) {
        return $.trim(value) !== "";
    }, "This field cannot be empty or just spaces");

    $('#newProductForm').validate({
        rules: {
            productID: {
                required: true,
                noSpace: true,
                remote: {
                    url: '/dashboard/checkProductExistence',
                    type: 'POST',
                    data: {
                        productID: function () {
                            return $('#productID').val();
                        }
                    },
                    dataFilter: function (response) {
                        const res = JSON.parse(response);
                        return res.exists ? "false" : "true";
                    }
                }
            },
            productName: {
                required: true,
                noSpace: true,                
            }
        },
        messages: {
            productID: {
                required: "Please enter the product ID",
                noSpace: "Product ID cannot be empty",
                remote: "This Product ID already exists"
            },
            productName: {
                required: "Please enter the product name",
                noSpace: "Product name cannot be empty",                
            }
        },
        errorPlacement: function (error, element) {
            error.insertAfter(element);
        },
        highlight: function (element) {
            $(element).addClass('input-error');
        },
        unhighlight: function (element) {
            $(element).removeClass('input-error');
        },
        onkeyup: function (element) {
            $(element).valid();
        },
        onfocusout: function (element) {
            $(element).valid();
        },
        submitHandler: function (form) {
            form.submit();
        }
    });

});
