require('dotenv').config();

const usersModel = require('./src/models/userModel');
const { users } = require('./src/seeder/seeder');

const server = require('./src/serverapp');
const sequelize = require('./src/config/db');   // ✅ FIXED: import DB, not server

const PORT = process.env.PORT || 3032;

sequelize.sync({ alter: true })
    .then(async () => {
        console.log("Database synced");
        await usersModel.bulkCreate(users);
    })
    .then(() => {
        server.listen(PORT, () => {
            console.log(`Server running at http://localhost:${PORT}`);
        });
    })
    .catch((error) => {
        console.log("Error while connecting DB and starting server", error);
    });
